/*
 * ProjectileDamageActor.h
 *
 * Created 9/12/2009 By Johnny Huynh
 *
 * Version 00.00.01 9/12/2009
 *
 * Copyright Information:
 * All content copyright  2009 Johnny Huynh. All rights reserved.
 */
 
 #ifndef PROJECTILE_DAMAGE_ACTOR_H
 #define PROJECTILE_DAMAGE_ACTOR_H
 
 template <typename T> class ProjectileDamageActor;
 
 #include "CollisionHandlerEventNode.h"
 #include "DamageActor.h"
 #include "ProjectileDamageObject.h"
 
 #include "global.h"
 
 /**
  * Class specification for ProjectileDamageActor
  * A ProjectileDamageActor is a projectile that deals damage
  */
 template <typename T>
 class ProjectileDamageActor : public ProjectileDamageObject<T>, public DamageActor<T>
 {
 // Data Members
 private:
 
 // Local Functions
 public:
    ProjectileDamageActor( const std::string& name, const T& damage = ZERO ); 
    ProjectileDamageActor( const std::string& name, const T& damage, const EffectInfoCollection<T>& effect_info_collection ); 
    ProjectileDamageActor( const ProjectileDamageActor<T>& proj_dmg_actor );
    virtual ~ProjectileDamageActor();
    inline ProjectileDamageActor<T>& operator=( const ProjectileDamageActor<T>& proj_dmg_actor );
    virtual inline std::string get_default_collider_name() const {return "test";}//= 0;
    virtual inline void load_model( WindowFramework& window ) {}//= 0;
    virtual inline void load_model( WindowFramework& window, const NodePath& parent ) {}//= 0;
    
    // overloaded functions (NodePath)
    /*static void init_type() {
                                std::string template_type( typeid( T ).name() );
                                register_type(_type_handle, "ProjectileDamageActor<" + template_type + ">" );
                            }*/
 
 // Private Functions
 private:
    
 // Public Static Functions
 public:
    
 };
 
 /** LOCAL FUNCTIONS **/
 
 /**
  * Constructor
  */
 template <typename T>
 ProjectileDamageActor<T>::ProjectileDamageActor( const std::string& name, const T& damage )
                          : ProjectileDamageObject<T>( name, damage ),
                            DamageActor<T>( name, damage ),
                            DamageObject<T>( name, damage )
 {
    
 }
 
 /**
  * Alternative Constructor
  */
 template <typename T>
 ProjectileDamageActor<T>::ProjectileDamageActor( const std::string& name, const T& damage, const EffectInfoCollection<T>& effect_info_collection )
                          : ProjectileDamageObject<T>( name, damage, effect_info_collection ),
                            DamageActor<T>( name, damage, effect_info_collection ),
                            DamageObject<T>( name, damage, effect_info_collection )
 {
    
 }
 
 /**
  * Copy Constructor
  */
 template <typename T>
 ProjectileDamageActor<T>::ProjectileDamageActor( const ProjectileDamageActor<T>& proj_dmg_actor )
                          : ProjectileDamageActor<T>( proj_dmg_actor ),
                            DamageActor<T>( proj_dmg_actor ),
                            DamageObject<T>( proj_dmg_actor )
 {
    
 }
 
 /**
  * Destructor
  */
 template <typename T>
 ProjectileDamageActor<T>::~ProjectileDamageActor()
 {
    
 }
 
 /**
  * operator=() copies the content of the specified ProjectileDamageActor to this ProjectileDamageActor.
  *
  * @param (const ProjectileDamageActor<T>& proj_dmg_actor )
  * @return ProjectileDamageActor<T>&
  */
 template <typename T>
 inline ProjectileDamageActor<T>& ProjectileDamageActor<T>::operator=( const ProjectileDamageActor<T>&  proj_dmg_actor )
 {
    ProjectileDamageObject<T>::operator=( static_cast< ProjectileDamageObject<T> >( proj_dmg_actor ) );
    DamageActor<T>::operator=( static_cast< DamageActor<T> >( proj_dmg_actor ) );
    
    return *this;
 }
 
 #endif // PROJECTILE_DAMAGE_ACTOR_H